/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryAsyncRead;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;

/**
 * A request for retrieving an ElementClass based on an {@link ElementFactory},
 * an element type (Resource), {@link ICanvasContext} and {@link IDiagram}. Only
 * the canvas context and the element type are considered to identify the
 * request uniquely. ElementFactory is not a part of the identification since
 * element factories are originally resolved from element types and the at least
 * the current implementations do not have proper equals/hashCode
 * implementations which of destroys the possibility of DB request caching.
 * 
 * @author Tuukka Lehtonen
 */
class CreateElementClassRequest extends BinaryAsyncRead<Resource, ICanvasContext, ElementClass> {

    private final ElementFactory elementFactory;
    private final IDiagram       diagram;

    public CreateElementClassRequest(ElementFactory elementFactory, Resource elementType, ICanvasContext canvas, IDiagram diagram) {
        super(elementType, canvas);
        this.elementFactory = elementFactory;
        this.diagram = diagram;
    }

    @Override
    public void perform(AsyncReadGraph graph, AsyncProcedure<ElementClass> procedure) {
        elementFactory.create(graph, parameter2, diagram, parameter, procedure);
    }

}