/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;


import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.AsyncProcedureAdapter;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.elementclass.BranchPoint;
import org.simantics.g2d.elementclass.BranchPoint.Direction;
import org.simantics.g2d.elementclass.BranchPointClass;

/**
 * @author Tuukka Lehtonen
 */
public class BranchPointClassFactory extends ElementFactoryAdapter {

    public static ElementClass create(Resource elementClass) {
        return BranchPointClass.CLASS.newClassWith(false, new StaticObjectAdapter(elementClass));
    }

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, BranchPointClass.CLASS.newClassWith(false, new StaticObjectAdapter(elementType)));
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource element, final IElement e, final AsyncProcedure<IElement> procedure) {
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, TransformSynchronizer.INSTANCE);

        final AsyncProcedure<IElement> guard = new GuardedAsyncProcedureWrapper<IElement>(procedure, 2);

        final BranchPoint bp = e.getElementClass().getAtMostOneItemOfClass(BranchPoint.class);
        if (bp != null) {
            final DiagramResource dr = graph.getService(DiagramResource.class);
            graph.forHasStatement(element, dr.Horizontal, element, new AsyncProcedureAdapter<Boolean>() {
                @Override
                public void exception(AsyncReadGraph graph, Throwable throwable) {
                    guard.exception(graph, throwable);
                }
                @Override
                public void execute(AsyncReadGraph graph, final Boolean horizontal) {
                    graph.forHasStatement(element, dr.Vertical, element, new AsyncProcedure<Boolean>() {
                        @Override
                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            guard.exception(graph, throwable);
                        }
                        @Override
                        public void execute(AsyncReadGraph graph, Boolean vertical) {
                            Direction direction = Direction.Any;
                            if (horizontal ^ vertical)
                                direction = horizontal ? Direction.Horizontal : Direction.Vertical;
                            bp.setDirectionPreference(e, direction);

                            guard.execute(graph, e);
                        }
                    });
                }
            });
        }

        ElementFactoryUtil.readTransform(graph, element, e, guard);
    }

}