/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.request.AsyncRead;
import org.simantics.g2d.canvas.ICanvasContext;

public abstract class BaseRequest2<T, Result> implements AsyncRead<Result> {

    final protected T    data;

    final int            hash;

    final ICanvasContext canvas;

    //String               debug;

    public BaseRequest2(ICanvasContext canvas, T data) {
        this.canvas = canvas;
        assert canvas != null;
        assert data != null;
        this.data = data;
        this.hash = data.hashCode() + 31 * canvas.hashCode();
    }

    @Override
    public int hashCode() {
        return hash;
    }

    public int threadHash() {
    	return hash;
    }
    
    @Override
    public boolean equals(Object other) {
        if (this == other)
            return true;
        if (other == null || getClass() != other.getClass())
            return false;
        BaseRequest2<?, ?> o = (BaseRequest2<?, ?>) other;
        return data.equals(o.data) && canvas.equals(o.canvas);
    }

    @Override
    public int getFlags() {
        return 0;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + data + " - " + canvas.hashCode() + /*" " + debug +*/ "]";
    }

}

