/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorPart;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.utils.datastructures.hints.IHintContext;

/**
 * An Eclipse property tester for canvas editor tool mode.
 * 
 * @author Tuukka Lehtonen
 */
public class ToolPropertyTester extends PropertyTester {

    private static final String MODE = "mode";

    @Override
    public boolean test(Object receiver, final String property, final Object[] args, final Object expectedValue) {
        if (!(receiver instanceof IEditorPart))
            return false;
        IEditorPart editor = (IEditorPart) receiver;

        if (MODE.equals(property)) {
            ICanvasContext ctx = (ICanvasContext) editor.getAdapter(ICanvasContext.class);
            if (ctx == null)
                return false;

            IHintContext hints = ctx.getDefaultHintContext();
            IToolMode toolMode = hints.getHint(Hints.KEY_TOOL);
            if (toolMode != null) {
                return toolMode.getId().equals(expectedValue);
            }
        }
        return false;
    }

}
