/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.ui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;

public class ElementClassTransferable implements Transferable, ClipboardOwner {

	public static final DataFlavor FLAVOR = new DataFlavor( ResourceElementClassTransferData.class, "Element Class" );

	public static class ResourceElementClassTransferData implements Serializable {
		private static final long serialVersionUID = -4990050837054070697L;
		public String elementClassResourceRandomAccessReference[];	
	}
	
	private ResourceElementClassTransferData data;

	/**
	 * Creates a <code>Transferable</code> capable of transferring the specified
	 * <code>String</code>.
	 */
	public ElementClassTransferable(ResourceElementClassTransferData data) {
		this.data = data;
	}

	/**
	 * Returns an array of flavors in which this <code>Transferable</code> can
	 * provide the data. <code>DataFlavor.stringFlavor</code> is properly
	 * supported. Support for <code>DataFlavor.plainTextFlavor</code> is
	 * <b>deprecated</b>.
	 * 
	 * @return an array of length two, whose elements are <code>DataFlavor.
	 *         stringFlavor</code> and <code>DataFlavor.plainTextFlavor</code>
	 */
	public DataFlavor[] getTransferDataFlavors() {
		return new DataFlavor[] { FLAVOR }; 
	}

	public boolean isDataFlavorSupported(DataFlavor flavor) {
		return flavor.equals(FLAVOR);
	}

	public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
		if (flavor.equals(FLAVOR)) 
			return (ResourceElementClassTransferData) data;
		throw new UnsupportedFlavorException(flavor);
	}

	public void lostOwnership(Clipboard clipboard, Transferable contents) {
	}

}
