/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.g2d.element.ElementHints;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * One should implement
 * {@link #hintChanged(ISynchronizationContext, IModificationQueue, Resource, IHintObservable, Key, Object, Object)}
 * and
 * {@link #getSynchronizedHints()}.
 * 
 * @author Tuukka Lehtonen
 */
public abstract class ResourceSynchronizer implements IHintSynchronizer {

    @Override
    public final int synchronize(ISynchronizationContext context, IHintObservable observable) {
        Object o = observable.getHint(ElementHints.KEY_OBJECT);
        if (o instanceof Resource) {
            IModificationQueue queue = context.get(SynchronizationHints.MODIFICATION_QUEUE);
            return synchronize(context, queue, (Resource) o, observable);
        }
        return 0;
    }

    public abstract Key[] getSynchronizedHints();

    public int synchronize(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable observable) {
        int count = 0;
        for (Key key : getSynchronizedHints()) {
            count += synchronizeHint(context, queue, object, observable, key);
        }
        return count;
    }

    protected final int synchronizeHint(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable observable, Key key) {
        return hintChanged(context, queue, object, observable, key, null, observable.getHint(key)) ? 1 : 0;
    }

    @Override
    public final boolean hintChanged(ISynchronizationContext context, IHintObservable sender, Key key, Object oldValue, Object newValue) {
        Object o = sender.getHint(ElementHints.KEY_OBJECT);
        if (o instanceof Resource) {
            IModificationQueue queue = context.get(SynchronizationHints.MODIFICATION_QUEUE);
            return hintChanged(context, queue, (Resource) o, sender, key, oldValue, newValue);
        }
        return false;
    }

    @Override
    public final boolean hintRemoved(ISynchronizationContext context, IHintObservable sender, Key key, Object oldValue) {
        Object o = sender.getHint(ElementHints.KEY_OBJECT);
        if (o instanceof Resource) {
            IModificationQueue queue = context.get(SynchronizationHints.MODIFICATION_QUEUE);
            return hintRemoved(context, queue, (Resource) o, sender, key, oldValue);
        }
        return false;
    }

    public abstract boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue, Object newValue);

    public boolean hintRemoved(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue) {
        return false;
    }

}
