/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * @author Tuukka Lehtonen
 */
public final class GraphSynchronizationHints {

    public static final Key SESSION          = new KeyOf(Session.class, "DATABASE_SESSION");

    public static final Key READ_TRANSACTION = new KeyOf(ReadGraph.class, "READ_TRANSACTION");

    public static final Key WRITE_TRANSACTION = new KeyOf(WriteGraph.class, "WRITE_TRANSACTION");

    public static final Key BASIC_RESOURCES  = new KeyOf(BasicResources.class, "BASIC_RESOURCES");

    public static final Key GRAPH_LAYER_MANAGER = new KeyOf(GraphLayerManager.class, "GRAPH_LAYER_MANAGER");

}
