/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.diagram.internal.DebugPolicy;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.utils.datastructures.hints.HintContext;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Tuukka Lehtonen
 */
public class GraphSynchronizationContext implements IModifiableSynchronizationContext {

    private final IHintContext ctx = new HintContext();

    public GraphSynchronizationContext(ReadGraph graph, IModificationQueue modificationQueue) {
        ctx.setHint(GraphSynchronizationHints.SESSION, graph.getSession());
        ctx.setHint(GraphSynchronizationHints.BASIC_RESOURCES, BasicResources.getInstance(graph));
        ctx.setHint(SynchronizationHints.MODIFICATION_QUEUE, modificationQueue);
    }

    public static GraphSynchronizationContext getWriteInstance(WriteGraph graph, IModificationQueue modificationQueue) {
        GraphSynchronizationContext ctx = new GraphSynchronizationContext(graph, modificationQueue);
        ctx.ctx.setHint(GraphSynchronizationHints.READ_TRANSACTION, graph);
        ctx.ctx.setHint(GraphSynchronizationHints.WRITE_TRANSACTION, graph);
        return ctx;
    }

    @Override
    public <T> T get(Key key) {
        return ctx.getHint(key);
    }

    @Override
    public <T> T set(Key key, Object value) {
        if (DebugPolicy.DEBUG_SYNC_CONTEXT)
            System.out.println(this + ".set(" + key + "): " + value);

        if (value == null)
            return ctx.removeHint(key);

        T t = ctx.getHint(key);
        ctx.setHint(key, value);
        return t;
    }

}