/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class EnumerationModification extends ModificationAdapter {

    private final Resource owner;
    private final Resource relation;
    private final Resource value;

    public EnumerationModification(Resource propertyOwner, Resource propertyRelation, Resource value) {
        super(LOW_PRIORITY);
        this.owner = propertyOwner;
        this.relation = propertyRelation;
        this.value = value;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        g.deny(owner, relation);
        g.claim(owner, relation, value);
    }

}
