/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.g2d.element.IElement;

/**
 * This interface is used by DiagramGraphSynchronizer as a first time only
 * mechanism for customizable IElement->Graph synchronization of element that
 * have been newly added to a diagram. These methods are only invoked once for
 * any single element.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see IHintSynchronizer
 * 
 * TODO: try to unify this with other elementloader/graphelementfactory etc. mechanisms
 * TODO: transform this into ElementGraphLifecycle ?
 */
public interface ElementWriter {

    /**
     * @param graph
     * @param element
     * @param elementResource
     * @throws DatabaseException
     */
    void addToGraph(WriteGraph graph, IElement element, Resource elementResource) throws DatabaseException;

    /**
     * Sometimes {@link #writeGraph(WriteGraph, IElement, Resource)}
     * can write things into the graph that are not removed by the standard
     * deletion procedure. The standard procedure is to remove the element
     * resource from the diagram's ordered set and then remove everything that
     * the element resource <em>is composed of</em>. This method may implement
     * customized code for removing any other kinds of affiliations the element
     * might have in the graph.
     * 
     * @param graph
     * @param elementResource
     */
    void removeFromGraph(WriteGraph graph, Resource elementResource) throws DatabaseException;

}
