/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Tuukka Lehtonen
 */
public final class BasicResources {

    public final Layer0              L0;
    public final G2DResource         G2D;
    public final DiagramResource     DIA;
    public final StructuralResource2 STR;

    public BasicResources(ReadGraph graph) {
        L0 = Layer0.getInstance(graph);
        G2D = G2DResource.getInstance(graph);
        DIA = DiagramResource.getInstance(graph);
        STR = StructuralResource2.getInstance(graph);
    }

    public static BasicResources getInstance(ReadGraph graph) {
        BasicResources br = graph.peekService(BasicResources.class);
        if (br == null) {
            br = new BasicResources(graph);
            graph.registerService(BasicResources.class, br);
        }
        return br;
    }

    public static BasicResources getInstance(Session session) throws DatabaseException {
        BasicResources ret = session.peekService(BasicResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<BasicResources>() {
                @Override
                public BasicResources perform(ReadGraph graph) throws DatabaseException {
                    return new BasicResources(graph);
                }
            });
            session.registerService(BasicResources.class, ret);
        }
        return ret;
    }

}
