/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary.ui;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.PageBookView;

/**
 * @author Tuukka Lehtonen
 */
public class ActivateFilterHandler extends AbstractHandler {

    FilterArea getFilterArea(IWorkbenchPart part) {
        if (part instanceof SymbolLibraryView) {
            SymbolLibraryView slv = (SymbolLibraryView) part;
            return slv.getFilterArea();
        }
        if (part instanceof SymbolPageView) {
            PageBookView pv = (PageBookView) part;
            IPage page = pv.getCurrentPage();
            Control ctrl = page.getControl();
            if (ctrl instanceof SymbolLibraryComposite) {
                return ((SymbolLibraryComposite) ctrl).getFilterArea();
            }
        }
        return null;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked(event);
        FilterArea filter = getFilterArea(part);
        if (filter != null && !filter.isDisposed())
            filter.focus();
        return null;
    }

}
