/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary;

import java.util.Collection;

import org.simantics.project.IProject;
import org.simantics.project.IProjectService;
import org.simantics.utils.datastructures.disposable.IDisposable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

public interface ISymbolManager extends IDisposable, IProjectService {

    /**
     * A key for storing an ISymbolManager in an IHintContext. This is used with
     * {@link IProject}.
     */
    Key KEY_SYMBOL_MANAGER = new KeyOf(ISymbolManager.class);

    /**
     * A key for storing a collection of {@link ISymbolGroup} instances in a
     * IHintContext. This is used with IProject. Its value is managed by an
     * ISymbolManager.
     */
    Key KEY_SYMBOL_GROUPS = new KeyOf(Collection.class, "SYMBOL_GROUPS");

    void addEntryPoints(Collection<ISymbolGroup> eps);

    void removeEntryPoints(Collection<ISymbolGroup> eps);

}
