/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbollibrary;


/**
 * An interface representing a single group in a symbol library.
 * 
 * @author Tuukka Lehtonen
 */
public interface IModifiableSymbolGroup extends ISymbolGroup {

    /**
     * Each invocation will add a new listener regardless of whether the
     * listener was already registered or not.
     * 
     * @param listener
     */
    void addListener(ISymbolGroupListener listener);

    /**
     * Removes the first occurrence of listener. If the listener is added
     * multiple times, then it must be removed as many times.
     * 
     * @param listener
     */
    void removeListener(ISymbolGroupListener listener);

}
