/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;

/**
 * @author Tuukka Lehtonen
 */
public abstract class SymbolItem extends NamedObject implements ISymbolItem {

    private final ISymbolGroup group;
    private final String description;

    public SymbolItem(Object identification, String name, ISymbolGroup group) {
        this(identification, name, name, group);
    }

    public SymbolItem(Object identification, String name, String description, ISymbolGroup group) {
        super(identification, name);
        if (description == null)
            throw new NullPointerException("null description");
        if (group == null)
            throw new NullPointerException("null group");
        this.description = description;
        this.group = group;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public ISymbolGroup getGroup() {
        return group;
    }

}