/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.g2d.element.ElementClass;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.datastructures.hints.IHintObservable;

/**
 * An ISymbolItem proxy version that allows changing the ISymbolGroup returned
 * by {@link #getGroup()}.
 * 
 * @author Tuukka Lehtonen
 */
public class GroupProxySymbolItem implements ISymbolItem {

    private final ISymbolItem proxy;
    private final ISymbolGroup group;

    public GroupProxySymbolItem(ISymbolItem item, ISymbolGroup group) {
        if (item == null)
            throw new NullPointerException("null item");
        if (group == null)
            throw new NullPointerException("null group");
        this.proxy = item;
        this.group = group;
    }

    public ISymbolItem getSubject() {
        return proxy;
    }

    @Override
    public String getName() {
        return proxy.getName();
    }

    @Override
    public String getDescription() {
        return proxy.getDescription();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return proxy.getAdapter(adapter);
    }

    @Override
    public ElementClass getElementClass(IHintObservable hints) throws ProvisionException {
        return proxy.getElementClass(hints);
    }

    @Override
    public ISymbolGroup getGroup() {
        return group;
    }

    @Override
    public int hashCode() {
        return proxy.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return proxy.equals(obj);
    }

}