/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation for issue #4384
 *******************************************************************************/
package org.simantics.diagram.runtime;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.ui.workbench.IResourceEditorInput2;

/**
 * Extract a triple <Model URI, Variable URI, RVI> from the input argument. This
 * request is needed in addition to {@link RuntimeVariable} to support possible
 * changes in the data contained by {@link IResourceEditorInput2}.
 * 
 * Returns <code>null</code> if it cannot find:
 * <ol>
 * <li>model resource by its URI</li>
 * <li>active realization of the model or base realization as a fallback</li>
 * </ol>
 * 
 * @author Tuukka Lehtonen
 * @see RuntimeVariable
 */
class RuntimeVariableForInput extends UnaryRead<IResourceEditorInput2, RuntimeDiagramDesc> {

    public RuntimeVariableForInput(IResourceEditorInput2 input) {
        super(input);
    }

    @Override
    public RuntimeDiagramDesc perform(ReadGraph graph) throws DatabaseException {
        Resource model = parameter.getModel(graph);
        String rvis = parameter.getRVI();
        RVI rvi = rvis == null ? null : RVI.fromResourceFormat(graph, rvis);
        return graph.syncRequest(new RuntimeVariable(
                model,
                rvi,
                parameter.getResource()));
    }

}