/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.utils.page.PageDesc;

/**
 * Reads diagram page configuration.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 */
public class DiagramDescRead extends ResourceRead<DiagramDesc> {

    public DiagramDescRead(Resource diagramResource) {
        super(diagramResource);
    }

    @Override
    public DiagramDesc perform(ReadGraph graph) throws DatabaseException {
        PageDesc pdesc = DiagramGraphUtil.getPageDesc(graph, resource, null);
        if (pdesc == null)
            return null;

        double gridSize = DiagramGraphUtil.getGridSize(graph, resource, 1.0);
        boolean pageBordersVisible = DiagramGraphUtil.isPageBordersVisible(graph, resource);
        boolean marginsVisible = DiagramGraphUtil.isMarginsVisible(graph, resource);

        DiagramResource DIA = DiagramResource.getInstance(graph);
        boolean displayGrid = DiagramGraphUtil.getDiagramTagPreference(graph, resource, DIA.DisplayGrid);
        boolean displayRuler = DiagramGraphUtil.getDiagramTagPreference(graph, resource, DIA.DisplayRuler);

        return new DiagramDesc(pdesc, gridSize, pageBordersVisible, marginsVisible, displayGrid, displayRuler);
    }

}
