package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;

import org.simantics.datatypes.literal.Vec2d;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;

/**
 * @author Antti Villberg
 * @author Tuukka Lehtonen
 */
public abstract class IconButtonStyleBase<T extends IconButtonResult> extends StyleBase<T> {

	abstract protected String getNodePrefix();
	abstract protected Class<?> getNodeClass();

    public IconButtonStyleBase(Object identity) {
        super(identity);
    }

    public IconButtonStyleBase() {
        super();
    }

    private AffineTransform translateAndScaleIfNeeded(AffineTransform tr, Vec2d offset, boolean relativeTransform) {
    	if(relativeTransform) {
        	if(!offset.isZero()) {
        		tr = new AffineTransform(tr);
        		tr.translate(offset.x, offset.y);
        	}
    	} else {
        	Vec2d translation = new Vec2d(tr.getTranslateX()+offset.x, tr.getTranslateY()+offset.y);
    		tr = new AffineTransform();
    		tr.translate(translation.x, translation.y);
    	}
    	return tr;
    }
    
    private AffineTransform getSymbolTransform(INode node, Vec2d offset, boolean relativeTransform) {
    	if(node instanceof SingleElementNode) {
    		SingleElementNode s = (SingleElementNode)node;
    		INode symbol = NodeUtil.findChildByPrefix(s, "composite_image"); 
        	return translateAndScaleIfNeeded(symbol != null ? ((IG2DNode)symbol).getTransform() : new AffineTransform(), offset, relativeTransform);
    	}
    	return null;
    }
    
    @Override
    public void applyStyleForNode(EvaluationContext observer, INode node, T result) {

    	if (result == null) {
            ProfileVariables.denyChildren(node, getNodePrefix());
            return;
        }

    	IconButtonState state = result.getState();
    	IconButtonConfiguration config = state.getConfiguration(); 
    	
    	if (config.getOffset() == null) {
    		ProfileVariables.denyChild(node, getNodePrefix() + config.getId());
    		return;
    	}

    	@SuppressWarnings("unchecked")
		IconButtonNode iconNode = ProfileVariables.claimChild(node, "", getNodePrefix() + config.getId(), (Class<IconButtonNode>)getNodeClass(), observer);

        iconNode.setZIndex( Integer.MAX_VALUE );
        iconNode.setTransform( getSymbolTransform(node, config.getOffset(), config.getRelativeTransform()));

        iconNode.setData(result);
            
    }

    @Override
    protected void cleanupStyleForNode(EvaluationContext observer, INode node) {
    	ProfileVariables.denyChildren(node, getNodePrefix());
    }

}
