/*******************************************************************************
 * Copyright (c) 2020 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.participant;

import java.nio.charset.StandardCharsets;

import org.eclipse.swt.dnd.ByteArrayTransfer;

public class SVGTransfer extends ByteArrayTransfer {
    private static SVGTransfer instance = new SVGTransfer();
    private static final String TYPE_NAME = "image/svg+xml";
    private static final int TYPE_ID = registerType(TYPE_NAME);

    public static byte[] formatContent(String svg) {
        return svg.getBytes(StandardCharsets.UTF_8);
    }

    public static SVGTransfer getInstance () {
        return instance;
    }

    @Override
    protected int[] getTypeIds(){
        return new int[] {TYPE_ID};
    }

    @Override
    protected String[] getTypeNames(){
        return new String[] {TYPE_NAME};
    }
}