/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.participant;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Set;

import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil.TerminalInfo;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;

/**
 * Adds support for drawing connections through {@link ConnectTool2} and
 * {@link RouteGraphConnectTool} to {@link PointerInteractor}.
 * 
 * @author Tuukka Lehtonen
 */
public class PointerInteractor2 extends PointerInteractor {

    public PointerInteractor2() {
        this(true, true, true, false, true, false, ElementClassProviders.staticProvider(null));
    }

    public PointerInteractor2(boolean clickSelect, boolean boxSelect, boolean dragElement, boolean dndDragElement, boolean connect, IElementClassProvider newConnectionClassProvider) {
        this(clickSelect, boxSelect, dragElement, dndDragElement, connect, false, newConnectionClassProvider);
    }

    public PointerInteractor2(boolean clickSelect, boolean boxSelect, boolean dragElement, boolean dndDragElement, boolean connect, boolean doubleClickEdit, IElementClassProvider newConnectionClassProvider) {
        super(clickSelect, boxSelect, dragElement, dndDragElement, connect, doubleClickEdit, newConnectionClassProvider, null); 
    }

    @Override
    protected ICanvasParticipant createConnectTool(TerminalInfo ti, int mouseId, Point2D startCanvasPos) {
        return new ConnectTool2(ti, mouseId, startCanvasPos);
    }

    @Override
    protected ICanvasParticipant createConnectToolWithTerminals(List<TerminalInfo> tis, int mouseId, Point2D startCanvasPos) {
        return new ConnectTool2(tis, mouseId, startCanvasPos);
    }

    protected ICanvasParticipant initiateRouteGraphConnectTool(RouteGraphTarget target, int mouseId) {
        return new RouteGraphConnectTool(target, mouseId);
    }

    @Override
    protected ICanvasParticipant createTranslateTool(int mouseId, Point2D startCanvasPos, Point2D curCanvasPos, Set<IElement> elementsToDrag) {
        return new TranslateMode2(startCanvasPos, curCanvasPos, mouseId, elementsToDrag);
    }

    protected boolean checkInitiateConnectTool(MouseEvent me, Point2D mouseCanvasPos) {
        // Pick Terminal
        IToolMode mode = getToolMode();
        if (mode == Hints.CONNECTTOOL || me.hasAnyModifier(MouseEvent.ALT_MASK | MouseEvent.ALT_GRAPH_MASK)) {
            //IConnectionAdvisor advisor = diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
            List<TerminalInfo> tis = pickTerminals(me.controlPosition);

            ICanvasParticipant bsi = null;

            if (tis.isEmpty()) {
                // Look for potential connection to branch.
                RouteGraphTarget cp = RouteGraphConnectTool.pickRouteGraphConnection(
                        getContext(), diagram,
                        getCanvasPickShape(me.controlPosition), getPickDistance());
                if (cp != null) {
                    bsi = initiateRouteGraphConnectTool(cp, me.mouseId);
                } else {
                    ISnapAdvisor snapAdvisor = getHint(DiagramHints.SNAP_ADVISOR);
                    if (snapAdvisor != null)
                        snapAdvisor.snap(mouseCanvasPos);

                    // Start connection out of thin air, without a terminal.
                    bsi = createConnectTool(null, me.mouseId, mouseCanvasPos);
                }
            } else {
                // Find the terminals that are equally close
                tis = TerminalUtil.findNearestOverlappingTerminals(tis);
                int tcount = tis.size();
                if (tcount > 0) {
                    if (tcount == 1) {
                        bsi = createConnectTool(tis.get(0), me.mouseId, mouseCanvasPos);
                    } else {
                        //System.out.println("many terminals (" + tcount + "):\n" + EString.implode(tis));
                        bsi = createConnectToolWithTerminals(tis, me.mouseId, mouseCanvasPos);
                    }
                }
            }

            // Did we catch anything?
            if (bsi != null) {
                startConnectTool(bsi);
                return true;
            }
        }

        return false;
    }

}
