package org.simantics.diagram.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.chassis.ICanvasChassis;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.ui.selection.WorkbenchSelectionUtils;

/**
 * @author Tuukka Lehtonen
 * @since 1.51.0
 */
public class DeleteRouteLine extends AbstractHandler {

	static ICanvasContext getCanvasContext(ExecutionEvent event) {
		ICanvasContext canvas = null;

		Event e = ((Event)event.getTrigger());
		if (e.widget instanceof ICanvasChassis) {
			ICanvasChassis chassis = (ICanvasChassis) e.widget;
			canvas = chassis.getCanvasContext();
		}
		if (canvas == null) {
			IWorkbenchPart part = HandlerUtil.getActiveEditor(event);
			if (part != null)
				canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
		}
		if (canvas == null) {
			IWorkbenchPart part = HandlerUtil.getActivePart(event);
			if (part != null)
				canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
		}
		return canvas;
	}

	static IDiagram getDiagram(ICanvasContext ctx) {
		return ctx.getDefaultHintContext().getHint(DiagramHints.KEY_DIAGRAM);
	}

	static DataElementMap getDataMap(IDiagram diagram) {
		return diagram.getDiagramClass().getSingleItem(DataElementMap.class);
	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		ISelection sel = HandlerUtil.getCurrentSelection(event);
		try {
			Resource r = WorkbenchSelectionUtils.getPossibleResource(sel);
			if (r != null) {
				ICanvasContext ctx = getCanvasContext(event);
				IDiagram diagram = getDiagram(ctx);
				DataElementMap dem = getDataMap(diagram);
				IElement e = dem.getElement(diagram, r);
				if (e != null) {
					Node node = e.getHint(RouteGraphConnectionClass.KEY_RG_NODE);
					if (node instanceof RouteGraphNode) {
						RouteGraphNode rgn = (RouteGraphNode) node;
						Simantics.getSession().markUndoPoint();
						rgn.deleteCurrentMouseTarget();
					}
				}
			}
			return null;
		} catch (DatabaseException e) {
			throw new ExecutionException("Failed to delete route line from selected connection", e);
		}
	}

}
