/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler;

import org.eclipse.core.runtime.IStatus;

/**
 * An additional interface for {@link CopyPasteStrategy} implementation to
 * implement. This can be used to control the set of elements allowed to be
 * copied/cut in the first place.
 * 
 * @author Tuukka Lehtonen
 * @see CopyPasteStrategy
 * @since 1.23
 */
public interface CopyStrategy {

    /**
     * @param operation
     *            the contents of the intended copy that this method is allowed
     *            to modify freely.
     * @return status to indicate whether the copy operation can succeed or not.
     *         An OK status indicates the copy operation is ok to commence. Any
     *         other status means that the strategy prevented copy the reason
     *         shown by the status.
     */
    IStatus copy(CopyOperation operation);

}
