/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.flag;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

import org.simantics.diagram.flag.IFlagType.FlagInfo;
import org.simantics.g2d.elementclass.FlagClass.Type;
import org.simantics.g2d.utils.Alignment;

/**
 * @author Tuukka Lehtonen
 */
public class FlagInfoImpl implements FlagInfo {

    private final Shape       shape;
    private final String[]    text;
    private final Type        type;
    private final Rectangle2D textArea;
    private final Alignment   horizontalAlignment;
    private final Alignment   verticalAlignment;
    private final Font        font;

    public FlagInfoImpl(Shape shape, String[] text, Type type, Rectangle2D textArea,
            Alignment horizontalAlignment, Alignment verticalAlignment, Font font) {
        this.shape = shape;
        this.text = text;
        this.type = type;
        this.textArea = textArea;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.font = font;
    }

    @Override
    public Shape getShape() {
        return shape;
    }

    @Override
    public String[] getText() {
        return text;
    }

    @Override
    public Type getType() {
        return type;
    }

    @Override
    public Rectangle2D getTextArea() {
        return textArea;
    }

    @Override
    public Alignment getHorizontalAlignment() {
        return horizontalAlignment;
    }

    @Override
    public Alignment getVerticalAlignment() {
        return verticalAlignment;
    }

    @Override
    public Font getFont() {
        return font;
    }
}
