/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.contribution;

import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.utils.ui.ExceptionUtils;


/**
 * @author Antti Villberg
 */
abstract public class WritingDiagramDynamicMenuContribution<T> extends DiagramDynamicMenuContribution<T> {
    
    @Override
    protected void perform(Session session, ICanvasContext context, final T input) {
    	
    	try {
    		session.syncRequest(new WriteRequest() {
    			@Override
    			public void perform(WriteGraph graph) throws DatabaseException {
    				WritingDiagramDynamicMenuContribution.this.perform(graph, input);
    			}
    		});
    	} catch (DatabaseException e) {
    		ExceptionUtils.logError(e);
    	}

	}

    abstract protected void perform(WriteGraph graph, T input) throws DatabaseException;

    
}
