/*******************************************************************************
 * Copyright (c) 2007, 2018 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - Added getTerminals & getConnectionPoints
 *******************************************************************************/
package org.simantics.diagram.content;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.simantics.db.Resource;

/**
 * terminal <-> connection point
 * 
 * @author Tuukka Lehtonen
 */
public class TerminalMap {

    public static final TerminalMap EMPTY = new TerminalMap(0) {
        public void put(Resource terminal, Resource connectionPoint) {
            throw new UnsupportedOperationException("immutable TerminalMap");
        }
    };

    private final Map<Resource, Resource> leftToRight;
    private final Map<Resource, Resource> rightToLeft;

    public TerminalMap(int initialCapacity) {
        leftToRight = new HashMap<Resource, Resource>(initialCapacity);
        rightToLeft = new HashMap<Resource, Resource>(initialCapacity);
    }

    public Resource getConnectionPoint(Resource terminal) {
        return leftToRight.get(terminal);
    }

    public Resource getTerminal(Resource connectionPoint) {
        return rightToLeft.get(connectionPoint);
    }

    public void put(Resource terminal, Resource connectionPoint) {
        leftToRight.put(terminal, connectionPoint);
        rightToLeft.put(connectionPoint, terminal);
    }

    /**
     * @since 1.36.0
     */
    public Set<Resource> getTerminals() {
        return leftToRight.keySet();
    }

    /**
     * @since 1.36.0
     */
    public Set<Resource> getConnectionPoints() {
        return rightToLeft.keySet();
    }

}
