/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.content;

import java.util.EnumSet;
import java.util.StringTokenizer;

import org.simantics.g2d.connection.EdgeVisualsConfigurer;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.EdgeVisuals.ArrowType;
import org.simantics.g2d.element.handler.EdgeVisuals.EdgeEnd;

/**
 * @author Tuukka Lehtonen
 */
public class ArrowConfigurer implements EdgeVisualsConfigurer {

    private ArrowType arrow     = ArrowType.None;
    private double    arrowSize = 1.0;

    public ArrowConfigurer() {
    }

    public ArrowConfigurer(ArrowType arrow, double arrowSize) {
        this.arrow = arrow;
        this.arrowSize = arrowSize;
    }

    public ArrowConfigurer(String description) {
        StringTokenizer tokenizer = new StringTokenizer(description);
        if (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            this.arrow = parseType(type);
        }
        if (tokenizer.hasMoreTokens()) {
            String size = tokenizer.nextToken();
            this.arrowSize = parseSize(size);
        }
    }

    private double parseSize(String size) {
        try {
            return Double.parseDouble(size);
        } catch (NumberFormatException e) {
            return 1.0;
        }
    }

    private ArrowType parseType(String type) {
        String lower = type.toLowerCase();
        if ("none".equals(lower))
            return ArrowType.None;
        if ("stroke".equals(lower))
            return ArrowType.Stroke;
        if ("fill".equals(lower))
            return ArrowType.Fill;
        if ("both".equals(lower))
            return ArrowType.Both;
        throw new IllegalArgumentException("unrecognized arrow type: " + type);
    }

    @Override
    public void configure(IElement edge, EdgeVisuals visuals, EnumSet<EdgeEnd> ends) {
        for (EdgeEnd end : ends) {
            visuals.setArrowType(edge, end, arrow);
            visuals.setArrowSize(edge, end, arrowSize);
        }
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + arrow + " " + arrowSize + "]";
    }

}
