/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.impl.Element;

/**
 * @author Antti Villberg
 */
class SpawnEdgeRequest extends BaseRequest2<EdgeResource, IElement> {

    private final ElementClass clazz;

    public SpawnEdgeRequest(ICanvasContext canvas, ElementClass clazz, EdgeResource resource) {
        super(canvas, resource);
        this.clazz = clazz;
    }

    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<IElement> procedure) {
//        System.out.println("Spawn " + data);
        IElement e = Element.spawnNew(clazz);
        e.setHint(ElementHints.KEY_OBJECT, data);
        procedure.execute(graph, e);
    }

}
