/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.procedure.Listener;

/**
 * @author Tuukka Lehtonen
 *
 * @param <T>
 */
public abstract class DisposableListener<T> implements Listener<T> {

    private final ListenerSupport support;
    private boolean               disposed = false;

    public DisposableListener(ListenerSupport support) {
        this.support = support;
    }

    /**
     * Forcefully and irreversibly dispose this listener.
     */
    public void disposeListener() {
        disposed = true;
    }

    @Override
    public void exception(Throwable t) {
        support.exception(t);
    }

    @Override
    public boolean isDisposed() {
        return disposed || support.isDisposed();
    }

}