/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.ResourceAdapter;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.handler.impl.LockingTransactionContext;
import org.simantics.g2d.diagram.handler.impl.PickContextImpl;
import org.simantics.g2d.elementclass.connection.ConnectionValidator;

public class DiagramClassAdapter implements ResourceAdapter<DiagramClass> {

    public static final DiagramClass INSTANCE = DiagramClass.compile(
            PickContextImpl.INSTANCE,
            LockingTransactionContext.INSTANCE,
            ConnectionValidator.INSTANCE
    );

    @Override
    public void adapt(AsyncReadGraph g, Resource source, Resource r, AsyncProcedure<DiagramClass> procedure) {
        procedure.execute(g, INSTANCE);
    }

}
