/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.content.DesignatedTerminal;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.structural2.modelingRules.IModelingRules;

/**
 * @author Tuukka Lehtonen
 */
public interface ConnectionVisualsLoader {

    /**
     * @param graph
     * @param modelingRules
     * @param connection
     * @param diagram
     * @param edge
     * @param firstTerminal
     * @param secondTerminal
     * @throws DatabaseException
     */
    public void loadConnectionVisuals(ReadGraph graph, IModelingRules modelingRules, Resource connection,
            IDiagram diagram, IElement edge, DesignatedTerminal firstTerminal, DesignatedTerminal secondTerminal)
    throws DatabaseException;

}
