package org.simantics.diagram.synchronization.graph.layer;

import java.util.Collection;

public class LayersSpec {
    private Collection<GraphLayer> graphLayers;

    public LayersSpec(Collection<GraphLayer> gls) {
        this.graphLayers = gls;
    }

    public Collection<GraphLayer> getGraphLayers() {
        return graphLayers;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((graphLayers == null) ? 0 : graphLayers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        LayersSpec other = (LayersSpec) obj;
        if (graphLayers == null) {
            if (other.graphLayers != null)
                return false;
        } else if (!graphLayers.equals(other.graphLayers))
            return false;
        return true;
    }

}
