/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph.layer;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbConsumer;
import org.simantics.g2d.layers.ILayer;
import org.simantics.g2d.layers.SimpleLayer;

/**
 * @author Tuukka Lehtonen
 */
public class GraphLayer {

    public static final String PROP_VISIBLE = "PROP_VISIBLE";
    public static final String PROP_FOCUSABLE = "PROP_FOCUSABLE";

    private final String   name;

    private final Resource layer;
    
    private boolean active;
    
    private final Map<String, Resource> tags;

    public GraphLayer(String name, Resource layer, Map<String, Resource> tags, boolean active) {
        this.name = name;
        this.layer = layer;
        this.tags = tags;
        this.active = active;
    }

    public GraphLayer withName(String name) {
        return new GraphLayer(name, layer, tags, active);
    }

    public String getName() {
        return name;
    }

    public Resource getLayer() {
        return layer;
    }

    public Resource getVisible() {
        return tags.get(PROP_VISIBLE);
    }

    public Resource getFocusable() {
        return tags.get(PROP_FOCUSABLE);
    }
    
    public boolean isActive() {
        return active;
    }

    public ILayer getILayer() {
        return new SimpleLayer(name);
    }

    public Collection<Resource> getTags() {
        return tags.values();
    }

    public void forEachTag(DbConsumer<Resource> consumer) throws DatabaseException {
        for (Resource r : tags.values())
            consumer.accept(r);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (active ? 1231 : 1237);
        result = prime * result + ((layer == null) ? 0 : layer.hashCode());
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((tags == null) ? 0 : tags.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        GraphLayer other = (GraphLayer) obj;
        if (active != other.active)
            return false;
        if (layer == null) {
            if (other.layer != null)
                return false;
        } else if (!layer.equals(other.layer))
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (tags == null) {
            if (other.tags != null)
                return false;
        } else if (!tags.equals(other.tags))
            return false;
        return true;
    }

}