/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.diagram.synchronization.IModificationQueue;
import org.simantics.diagram.synchronization.ISynchronizationContext;
import org.simantics.g2d.element.ElementHints;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.datastructures.hints.IHintContext.Key;

/**
 * @author Tuukka Lehtonen
 */
public class TransformSynchronizer extends ResourceSynchronizer {

    public static final TransformSynchronizer INSTANCE = new TransformSynchronizer();

    private static final Key[] SYNCHRONIZED_HINTS = {
        ElementHints.KEY_TRANSFORM,
        ElementHints.KEY_BOUNDS
    };

    @Override
    public Key[] getSynchronizedHints() {
        return SYNCHRONIZED_HINTS;
    }

    @Override
    public boolean hintChanged(ISynchronizationContext context, IModificationQueue queue, Resource object, IHintObservable sender, Key key, Object oldValue, Object newValue) {
    	if(newValue == null) return false;
    	if (ElementHints.KEY_TRANSFORM.equals(key)) {
            BasicResources br = context.get(GraphSynchronizationHints.BASIC_RESOURCES);

            final double[] flatmatrix = new double[6];
            ((AffineTransform) newValue).getMatrix(flatmatrix);

            return queue.offer(new PropertyModification(object, br.DIA.HasTransform, br.G2D.Transform, flatmatrix, Bindings.DOUBLE_ARRAY), null);
        } else if (ElementHints.KEY_BOUNDS.equals(key)) {
            BasicResources br = context.get(GraphSynchronizationHints.BASIC_RESOURCES);

            final double[] flatmatrix = new double[4];
            flatmatrix[0] = ((Rectangle2D)newValue).getMinX();
            flatmatrix[1] = ((Rectangle2D)newValue).getMinY();
            flatmatrix[2] = ((Rectangle2D)newValue).getWidth();
            flatmatrix[3] = ((Rectangle2D)newValue).getHeight();
            return queue.offer(new PropertyModification(object, br.G2D.HasBounds, br.G2D.Rectangle2D, flatmatrix, Bindings.DOUBLE_ARRAY), null);
        }
        
        return false;
    }

}
