/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization.graph;

import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.ModificationAdapter;

/**
 * @author Tuukka Lehtonen
 */
public class MoveRouteGraphConnection extends ModificationAdapter {

    Resource connection;
    double offsetx;
    double offsety;

    public MoveRouteGraphConnection(Resource connection, double offsetx, double offsety) {
        this(LOW_PRIORITY, connection, offsetx, offsety);
    }

    public MoveRouteGraphConnection(Double priority, Resource connection, double offsetx, double offsety) {
        super(priority);
        this.connection = connection;
        this.offsetx = offsetx;
        this.offsety = offsety;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);
        for (Resource node : graph.getObjects(connection, DIA.HasInteriorRouteNode)) {
            if (graph.isInstanceOf(node, DIA.RouteLine)) {
                Boolean isHorizontal = graph.getRelatedValue(node, DIA.IsHorizontal, Bindings.BOOLEAN);
                Double pos = graph.getRelatedValue(node, DIA.HasPosition, Bindings.DOUBLE);
                if (Boolean.TRUE.equals(isHorizontal))
                    pos += offsety;
                else
                    pos += offsetx;
                graph.claimLiteral(node, DIA.HasPosition, pos);
            }
        }

        CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
        graph.addMetadata(cm.add("Transformed " + connection));
    }

}
