/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.db.WriteGraph;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

/**
 * @author Tuukka Lehtonen
 */
public class ThreadingModificationProxy extends ModificationAdapter {
    private final IModification    m;
    private final IThreadWorkQueue completionThread;
    private final boolean          syncCompletion;

    public ThreadingModificationProxy(IModification m, IThreadWorkQueue completionThread, boolean syncCompletion) {
        super(m.getPriority());
        this.m = m;
        this.completionThread = completionThread;
        this.syncCompletion = syncCompletion;
    }
    @Override
    public void completed() {
        if (completionThread != null) {
            Runnable r = new Runnable() {
                @Override
                public void run() {
                    m.completed();
                }
            };
            if (syncCompletion)
                ThreadUtils.syncExec(completionThread, r);
            else
                ThreadUtils.asyncExec(completionThread, r);
        } else {
            m.completed();
        }
    }
    @Override
    public boolean isComplete() {
        return m.isComplete();
    }
    @Override
    public void markComplete() {
        m.markComplete();
    }
    @Override
    public void perform(WriteGraph g) throws Exception {
        m.perform(g);
    }
    @Override
    public Throwable getException() {
        return m.getException();
    }
    @Override
    public void setException(Throwable t) {
        m.setException(t);
    }
    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + m + "]";
    }
}