/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.synchronization;

import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;

/**
 * A collection of {@link IHintContext} keys related to graph and diagram
 * synchronization.
 * 
 * @author Tuukka Lehtonen
 */
public final class SynchronizationHints {

    /**
     * A key for associating an {@link ISynchronizationContext} with an
     * {@link IDiagram}.
     */
    public static final Key CONTEXT                = new KeyOf(ISynchronizationContext.class, "SYNCHRONIZATION_CONTEXT");

    /**
     * A key for associating an {@link IElementClassProvider} with an
     * {@link ISynchronizationContext}.
     */
    public static final Key ELEMENT_CLASS_PROVIDER = new KeyOf(IElementClassProvider.class, "ELEMENT_CLASS_PROVIDER");

    /**
     * A key for associating an {@link ErrorHandler} with an
     * {@link ISynchronizationContext}.
     */
    public static final Key ERROR_HANDLER          = new KeyOf(ErrorHandler.class, "ERROR_HANDLER");

    /**
     * A key for associating an {@link IModificationQueue} with an
     * {@link ISynchronizationContext}.
     */
    public static final Key MODIFICATION_QUEUE     = new KeyOf(IModificationQueue.class, "MODIFICATION_QUEUE");

    /**
     * A key for associating a custom hint synchronizer to an {@link IElement}.
     */
    public static final Key HINT_SYNCHRONIZER      = new KeyOf(IHintSynchronizer.class, "HINT_SYNCHRONIZER");

    /**
     * A key for defining a {@link CopyAdvisor} to be used with a particular
     * {@link IDiagram}.
     */
    public static final Key COPY_ADVISOR           = new KeyOf(CopyAdvisor.class, "COPY_ADVISOR");

    /**
     * A key for hinting to a {@link CopyAdvisor} that it should not perform
     * renaming of the copied data.
     */
    public static final Key NO_RENAME              = new KeyOf(Boolean.class, "NO_RENAME");

    /**
     * A key for retrieving the curretly active project (see {@link IProject})
     * from an {@link ISynchronizationContext}.
     */
    public static final Key PROJECT                = ProjectKeys.KEY_PROJECT;

}
