/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.eclipse.core.runtime.IAdaptable;

/**
 * @author Tuukka Lehtonen
 */
public abstract class IdentifiedObject implements IAdaptable, IIdentifiedObject {
    Object identification;

    public IdentifiedObject(Object identification) {
        if (identification == null)
            throw new NullPointerException("null identification");
        this.identification = identification;
    }

    @Override
    public Object getId() {
        return identification;
    }

    @Override
    public int hashCode() {
        return identification.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof IdentifiedObject))
            return false;
        IdentifiedObject other = (IdentifiedObject) obj;
        return identification.equals(other.identification);
    }

    @SuppressWarnings("unchecked")
    protected <T> T adapt(Class<T> clazz) {
        if (clazz.isInstance(identification))
            return (T) identification;
        if (identification instanceof IAdaptable)
            return (T) ((IAdaptable) identification).getAdapter(clazz);
        return null;
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(identification))
            return identification;
        if (identification instanceof IAdaptable)
            return ((IAdaptable) identification).getAdapter(adapter);
        return null;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[id=" + identification + "]";
    }

}
