/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import java.util.Collection;

import org.simantics.diagram.symbollibrary.ISymbolGroup;

/**
 * An <code>ISymbolProvider</code> must be equals-comparable, i.e.
 * equals/hashCode need to be re-implemented. ISymbolProviders are considered to
 * be same if they provide the same <em>set</em> of symbol groups.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface ISymbolProvider {
    Collection<ISymbolGroup> getSymbolGroups();
    void setListener(Runnable listener);
    void dispose();
}
