/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - GitLab #1070
 *******************************************************************************/
package org.simantics.diagram.symbolcontribution;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;

public class BasicSymbolContribution implements SymbolContribution {

	final private Resource contribution;

	public BasicSymbolContribution(Resource contribution) {
		this.contribution = contribution;
	}

	public SymbolProviderFactory create(ReadGraph graph, Resource diagram) throws DatabaseException {
		return new BasicSymbolProviderFactory(graph, contribution, diagram);
	}
}
