/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import org.simantics.db.Resource;
import org.simantics.scl.runtime.tuple.Tuple4;

/**
 * @author Tuukka Lehtonen
 */
public class FlagTypeVisual extends Tuple4 {

    /**
     * @param flagTypeVisual
     * @param filteredPropertyReference
     * @param filterPattern
     * @param visualComposite
     */
    public FlagTypeVisual(Resource flagTypeVisual, String filteredPropertyReference, String filterPattern, Resource visualComposite) {
        super(flagTypeVisual, filteredPropertyReference, filterPattern, visualComposite);
        assert flagTypeVisual != null;
        assert visualComposite != null;
    }

    public Resource getFlagTypeVisual() {
        return (Resource) c0;
    }

    public String getFilteredPropertyReference() {
        return (String) c1;
    }

    public String getFilterPattern() {
        return (String) c2;
    }

    public Resource getVisualComposite() {
        return (Resource) c3;
    }
}
