/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.query;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;

/**
 * @author Hannu Niemisto
 */
public class FlagPairQuery extends ResourceRead<Resource> {

    public FlagPairQuery(Resource flag) {
        super(flag);
    }

    @Override
    public Resource perform(ReadGraph g) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance(g);

        Resource connectionJoin = g.getPossibleObject(resource, dr.FlagIsJoinedBy);
        if (connectionJoin == null)
            return null;

        for (Resource flag : g.getObjects(connectionJoin, dr.JoinsFlag)) {
            if (!flag.equals(resource))
                return flag;
        }

        return null;
    }
}
