package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.simantics.db.Resource;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Style;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public class StyleBaseData {

    private static StyleBaseData INSTANCE;

    private final Map<Style, List<Resource>> removals = new HashMap<>();

    private StyleBaseData() {
    }

    public static StyleBaseData getInstance() {
        if (INSTANCE == null) {
            synchronized (StyleBaseData.class) {
                if (INSTANCE == null) {
                    INSTANCE = new StyleBaseData();
                }
            }
        }
        return INSTANCE;
    }

    public synchronized void removeItem(Style s, Resource r) {
        List<Resource> l = removals.get(s);
        if (l == null) {
            l = new ArrayList<>();
            removals.put(s, l);
        }
        l.add(r);
    }

    public synchronized void applyRemovals(EvaluationContext evaluationContext, StyleBase<?> s) {
        List<Resource> rs = removals.remove(s);
        if (rs == null)
            return;

        DataNodeMap map = evaluationContext.getConstant(ProfileKeys.NODE_MAP);

        for (Resource item : rs) {
            s.cleanupStyleForItem(evaluationContext, map, item);
        }
    }

}
