/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile;

import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;

/**
 * Constants for accessing data within a scenegraph profile
 * {@link EvaluationContext} through
 * {@link EvaluationContext#getConstant(String)}.
 * 
 * @author Antti Villberg
 */
public class ProfileKeys {

    /**
     * Stores the {@link IDiagram} related to the profile evaluation.
     */
    public static String DIAGRAM  = "Diagram";

    /**
     * Stores the {@link ICanvasContext} related to the profile evaluation.
     */
    public static String CANVAS   = "Canvas";

    /**
     * Stores the {@link DataNodeMap} related to the profile evaluation.
     */
    public static String NODE_MAP = "NodeMap";

}
