package org.simantics.diagram.profile;

import java.util.Map;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.SimanticsClipboard.Representation;
import org.simantics.utils.datastructures.hints.IHintContext.Key;
import org.simantics.utils.datastructures.hints.IHintContext.KeyOf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Tuukka Lehtonen
 * @since 6.08
 */
public class ProfileActivityBeanRepresentation implements Representation {

	private static final Logger LOGGER = LoggerFactory.getLogger(ProfileActivityBeanRepresentation.class);

	public static Key KEY = new KeyOf(ProfileActivityBean.class, "PROFILE_ACTIVITY_BEAN");

	private final Resource source;
	private ProfileActivityBean bean;

	public ProfileActivityBeanRepresentation(Resource source) {
		this.source = source;
	}

	@Override
	public Key getKey() {
		return KEY;
	}

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getValue(RequestProcessor processor, Map<String,Object> hints) {
		if (bean == null) {
			try {
				bean = Profiles.readProfileActivity(processor, source);
			} catch (DatabaseException e) {
				LOGGER.error("Failed to read profile activity information from model " + source, e);
				// Prevent the code from attempting further reads from this source
				bean = new ProfileActivityBean();
			}
		}
		return (T) bean;
	}

}