/*******************************************************************************
 * Copyright (c) 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;

import org.simantics.common.color.Color;
import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 */
public class MonitorTextResult extends Tuple {
    public MonitorTextResult(String text, AffineTransform parentTransform) {
        super(text, parentTransform, null);
    }
    public MonitorTextResult(String text, AffineTransform parentTransform, Color color) {
        super(text, parentTransform, color);
    }
    public String getText() {
        return (String) getField(0);
    }
    public AffineTransform getParentTransform() {
        return (AffineTransform) getField(1);
    }
    public Color getColor() {
        return (Color) getField(2);
    }
}