package org.simantics.diagram.participant;

import java.awt.geom.Point2D;

import org.simantics.diagram.connection.RouteLine;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.utils.datastructures.map.Tuple;

/**
 * @author Tuukka Lehtonen
 */
public class RouteGraphTarget extends Tuple {
    public RouteGraphTarget(IElement e, RouteGraphNode rgn, RouteLine line, Point2D canvasPos, Point2D intersection) {
        super(e, rgn, line, canvasPos, intersection);
    }
    public IElement getElement() {
        return (IElement) getField(0);
    }
    public RouteGraphNode getNode() {
        return (RouteGraphNode) getField(1);
    }
    public RouteLine getLine() {
        return (RouteLine) getField(2);
    }
    public Point2D getCanvasPosition() {
        return (Point2D) getField(3);
    }
    public Point2D getIntersectionPosition() {
        return (Point2D) getField(4);
    }
}