/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.participant;

import java.util.Arrays;


/**
 * @author Tuukka Lehtonen
 * @author Teemu Lempinen
 */
public final class DiagramCommandBindings {

    public static void activateBindings(final ContextUtil ctxUtil, final String ... contextIds) {
        ctxUtil.inContextThread(new Runnable() {
            @Override
            public void run() {
                ctxUtil.activate(Arrays.asList(contextIds));
            }
        });
    }
    
    public static void activateBindings(final org.simantics.diagram.participant.e4.ContextUtil ctxUtil, final String ... contextIds) {
        ctxUtil.inContextThread(new Runnable() {
            @Override
            public void run() {
                ctxUtil.activate(Arrays.asList(contextIds));
            }
        });
    }

    public static void deactivateBindings(final ContextUtil ctxUtil, final String ... contextIds) {
        ctxUtil.inContextThread(new Runnable() {
            @Override
            public void run() {
                ctxUtil.deactivate(Arrays.asList(contextIds));
            }
        });
    }
    
    public static void deactivateBindings(final org.simantics.diagram.participant.e4.ContextUtil ctxUtil, final String ... contextIds) {
        ctxUtil.inContextThread(new Runnable() {
            @Override
            public void run() {
                ctxUtil.deactivate(Arrays.asList(contextIds));
            }
        });
    }
    
}
