/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.internal;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.scl.runtime.function.Function3;
import org.simantics.scl.runtime.function.FunctionImpl3;
import org.simantics.utils.FileUtils;

/**
 * @author Tuukka Lehtonen
 */
public class Activator extends AbstractUIPlugin {

    // The plug-in ID
    public static final String PLUGIN_ID = "org.simantics.diagram";

    // The shared instance
    private static Activator       plugin;

    public static ImageDescriptor LINK_ICON;
    public static ImageDescriptor LINK_BREAK_ICON;
    
    private static Map<String, String> iconTexts = new HashMap<String, String>();
    private static Map<String, String> iconDocumentCache = new HashMap<String, String>(); 

	public static Function3<String, RGB.Integer, Vec2d, String> ICON_PROVIDER = new FunctionImpl3<String, RGB.Integer, Vec2d, String>() {
		
		private String hex2(int value) {
			String result = Integer.toHexString(value);
			if(result.length() == 1) result = "0" + result;
			return result;
		}

		private int saturate(int in, double factor) {
			return (int)((double)in + factor*(double)(255-in));
		}

		private int darken(int in, double factor) {
			return (int)((double)in*factor);
		}
		
		@Override
		public String apply(String iconName, RGB.Integer rgb, Vec2d scale) {
			
	    	int r = rgb.red, g = rgb.green, b = rgb.blue; 
	    	String base = iconTexts.get(iconName);
	    	if(base == null) return null;
	    	
	    	int c4 = (r << 16) + (g << 8) + b;
	    	String key = iconName+c4+"#" + scale.x + "#" + scale.y;
	    	
	    	String cached = iconDocumentCache.get(key);
	    	if(cached == null) {
		    	int c1 = (saturate(r,0.83) << 16) + (saturate(g, 0.83) << 8) + saturate(b, 0.83);
		    	int c2 = (saturate(r,0.5) << 16) + (saturate(g, 0.5) << 8) + saturate(b, 0.5);
		    	int c3 = (saturate(r,0.16) << 16) + (saturate(g, 0.16) << 8) + saturate(b, 0.16);
		    	int c5 = (darken(r,0.83) << 16) + (darken(g, 0.83) << 8) + darken(b, 0.83);
		    	base = base.replace("!!c1!!", hex2(c1));
		    	base = base.replace("!!c2!!", hex2(c2));
		    	base = base.replace("!!c3!!", hex2(c3));
		    	base = base.replace("!!c4!!", hex2(c4));
		    	base = base.replace("!!scalex!!", "" + scale.x);
		    	base = base.replace("!!scaley!!", "" + scale.y);
		    	cached = base.replace("!!c5!!", hex2(c5));
		    	iconDocumentCache.put(key, cached);
	    	}
	    	return cached;
			
		}
		
	};
    
    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugins#start(org.osgi.framework.BundleContext)
     */
    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;

        Bundle bundle = context.getBundle();

        iconTexts.put("LED", FileUtils.getContents(bundle.getResource("icons/IconLed.svg")));
        iconTexts.put("TERMINAL", FileUtils.getContents(bundle.getResource("icons/IconTerminal.svg")));
        iconTexts.put("SQUARE", FileUtils.getContents(bundle.getResource("icons/IconSquare.svg")));
        
        iconTexts.put("BUTTON_ON", FileUtils.getContents(bundle.getResource("icons/ButtonOn.svg")));
        iconTexts.put("BUTTON_OFF", FileUtils.getContents(bundle.getResource("icons/ButtonOff.svg")));
        
        LINK_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/link.png"));
        LINK_BREAK_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/link_break.png"));
        
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.core.runtime.Plugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }

}
