/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.handler.e4;

import javax.inject.Named;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.scenegraph.g2d.events.EventDebugPolicy;
import org.simantics.scenegraph.g2d.events.EventQueue;
import org.simantics.scenegraph.g2d.events.command.Command;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * A handler for the Eclipse Command framework that delegates ID of the command
 * that triggered the event to the {@link EventQueue} of the
 * {@link ICanvasContext} where the event occurred.
 */
public class CanvasCommandDelegate {

    private final boolean DEBUG = EventDebugPolicy.CANVAS_COMMAND_DELEGATION;
    
    private static final String ACTIVE_PART_PARAMETER = "org.simantics.diagram.commandparameter.canvasCommandHandlerActiveWithPart";
    private static final String DELEGATE_PARAMETER = "org.simantics.diagram.commandparameter.canvasCommandDelegateParameter";

    @CanExecute
    public boolean canExecute(@Named(ACTIVE_PART_PARAMETER) String activePartId, @Named(IServiceConstants.ACTIVE_PART) MPart activePart) {
        if (activePart == null)
            return false;
        if (!(activePart.getObject() instanceof CompatibilityEditor))
            return false;
        CompatibilityEditor compatibilityEditor = (CompatibilityEditor) activePart.getObject();
        IEditorPart part = compatibilityEditor.getEditor();
        if (part == null)
        	return false;
        ICanvasContext ctx = part.getAdapter(ICanvasContext.class);
        if (ctx == null)
            return false;
        String id = compatibilityEditor.getReference().getId();
        if (!(id.equals(activePartId)))
            return false;
        return true;
    }
    
    @SuppressWarnings("restriction")
    @Execute
    public void execute(@Named(DELEGATE_PARAMETER) String commandId, @Named(IServiceConstants.ACTIVE_PART) MPart activePart) {
        CommandEvent ce = new CommandEvent(null, System.currentTimeMillis(), new Command(commandId));
        if (DEBUG)
            System.out.println(getClass().getSimpleName() + ": trigger event for command " + ce.command);

        Object object = activePart.getObject();
        
        IAdaptable part = null;
        if (object instanceof CompatibilityEditor) {
            CompatibilityEditor editor = (CompatibilityEditor) object;
            part = editor.getPart();
        } else if (object instanceof IAdaptable){
            part = (IAdaptable) object; 
        }
        ICanvasContext canvas = null;
        if (part != null)
            canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
        if (canvas == null) {
            part = WorkbenchUtils.getActiveWorkbenchPart();
            if (part != null)
                canvas = (ICanvasContext) part.getAdapter(ICanvasContext.class);
        }
        if (canvas != null) {
            if (DEBUG)
                System.out.println(getClass().getSimpleName() + ": sending command " + commandId + " to " + part);
            canvas.getEventQueue().queueEvent(ce);
        }
    }

}